"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from threading import Timer

class IntervalTimer:
    def __init__(self):
        self._timer = None
        self.interval = None
        self.function = None
        self.args = None
        self.kwargs = None
        self.is_running = False
        self.is_set = False

    def set(self, interval, function, *args, **kwargs):
        self.interval = interval
        self.function = function
        self.args = args
        self.kwargs = kwargs
        self.is_set = True
        self.start()

    def _run(self):
        self.is_running = False
        self.start()
        self.function(*self.args, **self.kwargs)

    def start(self):
        if not self.is_running:
            self._timer = Timer(self.interval, self._run)
            self._timer.start()
            self.is_running = True

    def stop(self):
        if self._timer is not None:
            self._timer.cancel()
            self.is_running = False

    def do_function(self):
        """ override the timer interval and perform the function immediately """
        self.stop()
        if not self.is_running and self.is_set:
            self._timer = Timer(0.5, self._run)
            self._timer.start()
            self.is_running = True

database_stats_timer = IntervalTimer()