"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('states/<str:swi_id>/', views.OneState.as_view(), name='one_swi_state'),
    path('states/', views.States.as_view(), name='swi_states'),
    path('configs/<str:swi_id>/', views.OneConfiguration.as_view(), name='one_swi_config'),
    path('configs/', views.Configurations.as_view(), name='swi_configs'),
    path('logs/<str:swi_id>/', views.Logs.as_view(), name='one_swi_logs'),
    path('automation/states/<str:swi_id>/', views.OneAutomationState.as_view(), name='one_automation_swi_state'),
    path('automation/states/', views.AutomationStates.as_view(), name='swi_automation_states'),
    path('automation/configs/Global/', views.GlobalAutomationConfig.as_view(), name='automation_global_config'),
    path('automation/configs/<str:cfg_id>/', views.OneAutomationConfig.as_view(), name='one_automation_swi_config'),
    path('automation/configs/', views.AutomationConfigs.as_view(), name='swi_automation_configs'),
]
