#!/usr/bin/env bash
# --------------------------------------------------------------------------#
#  Copyright (C) 2021 by Tibit Communications, Inc.                         #
#  All rights reserved.                                                     #
#                                                                           #
#     _______ ____  _ ______                                                #
#    /_  __(_) __ )(_)_  __/                                                #
#     / / / / __  / / / /                                                   #
#    / / / / /_/ / / / /                                                    #
#   /_/ /_/_____/_/ /_/                                                     #
#                                                                           #
#                                                                           #
#  Distributed as Tibit-Customer confidential                               #
#                                                                           #
# --------------------------------------------------------------------------#

TMPFILE=$(mktemp /tmp/tibit_nc_rpc.XXXXXX)

# Usage
usage () {
    cat <<HELP_USAGE

    $0 olt-name 
    or
    $0

    List GPON Interface info for OLTs configured on the NETCONF server.

    Options:
      -h|--help       Display this help and usage text.
      -p|--port       TCP port number used to connect to the NETCONF Server (default: 830).
      -s|--server     Hostname or IP address used to connect to the NETCONF Server (default: localhost).
      -u|--user       User used to connect to the NETCONF Server

    Example:
      List info of the GPON Interface of a Specific OLT.
      $0 70:bx:d5:54:15:9f
      List info of the GPON Interface for all OLTs at system.
      $0
HELP_USAGE

exit 0
}

# Defaults
HOST=localhost
PORT=830

# Parse command line arguments
PARAMS=""
while (( "$#" )); do
    case "$1" in
        -s|--server)
            HOST=$2
            shift 2
            ;;
        -p|--port)
            PORT=$2
            shift 2
            ;;
        -u|--user)
            USER=$2
            shift 2
            ;;
        -h|--help)
            usage
            ;;
        --) # end argument parsing
            shift
            break
            ;;
        -*|--*=) # unsupported option
            echo "Error: Unsupported option $1" >&2
            usage
            ;;
        *) # preserve positional arguments
            PARAMS="$PARAMS $1"
            shift
            ;;
    esac
done
# set positional arguments in their proper place
eval set -- "$PARAMS"
if [ -z "$1" ]
then
   NAME="<tibitcntlr:name/>"
else
   NAME="<tibitcntlr:name>"$1"</tibitcntlr:name>"
fi

if [ -z "$USER" ]
then
   LOGIN=""
else
   LOGIN="--login $USER"
fi


cat >${TMPFILE}  << EDITCONFIGXML
<get xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
    <filter type="subtree">
        <tibitcntlr:olt-state xmlns:tibitcntlr="urn:com:tibitcom:ns:yang:controller:db">
         <tibitcntlr:olt>
            $NAME
             <tibitcntlr:gpon>
                  <tibitcntlr:encryption/> 
                  <tibitcntlr:mac-address/>
                  <tibitcntlr:downstream-fec/>
             </tibitcntlr:gpon>
             <tibitcntlr:olt>
                  <tibitcntlr:laser-shutdown/>
                  <tibitcntlr:loss-of-signal/>
                  <tibitcntlr:pon-enable/>
                  <tibitcntlr:pon-mode/>
             </tibitcntlr:olt>
           </tibitcntlr:olt>
        </tibitcntlr:olt-state>
    </filter>
</get>
EDITCONFIGXML

PATH=${PATH}:/opt/tibit/netconf/bin netopeer2-cli <<COMMANDINPUT
connect --host ${HOST} --port ${PORT} ${LOGIN}
user-rpc --content ${TMPFILE} --rpc-timeout 120
exit
COMMANDINPUT

rm -rf ${TMPFILE}
