#!/usr/bin/env bash
#--------------------------------------------------------------------------#
# Copyright (C) 2015 - 2022 by Tibit Communications, Inc.                  #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
#--------------------------------------------------------------------------#
#
#Retrieve and print MCMS Package installed versions

PonMgrVersionInstalled="Not Installed"
PonCntlVersionInstalled="Not Installed"
PonNetconfVersionInstalled="Not Installed"

PonMgrVersionInstalled="$(apt-cache policy tibit-ponmgr | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonCntlVersionInstalled="$(apt-cache policy tibit-poncntl | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonNetconfVersionInstalled="$(apt-cache policy tibit-netconf | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"

if [ -z $PonMgrVersionInstalled ] || [ $PonMgrVersionInstalled == "" ] || [ $PonMgrVersionInstalled == " " ]; then
  PonMgrVersionInstalled="Not Installed"
else
  PonMgrVersionInstalled="R$PonMgrVersionInstalled"
fi
if [ -z $PonCntlVersionInstalled ] || [ $PonCntlVersionInstalled == "" ] || [ $PonCntlVersionInstalled == " " ]; then
  PonCntlVersionInstalled="Not Installed"
else
  PonCntlVersionInstalled="R$PonCntlVersionInstalled"
fi
if [ -z $PonNetconfVersionInstalled ] || [ $PonNetconfVersionInstalled == "" ] || [ $PonNetconfVersionInstalled == " " ]; then
  PonNetconfVersionInstalled="Not Installed"
else
  PonNetconfVersionInstalled="R$PonNetconfVersionInstalled"
fi

echo "MCMS Component Versions:
     PON Manager: $PonMgrVersionInstalled
     PON NETCONF: $PonNetconfVersionInstalled
  PON Controller: $PonCntlVersionInstalled
"

sudo systemctl status --no-pager --lines 0 mongod.service apache2.service tibit-*.service