#!/usr/bin/env bash

helpFunction()
{
   echo "Usage: sudo $0 -e <eth_interface>"
   exit 1 # Exit script after printing help
}

if [[ $(id -u) -ne 0 ]] ; then
    echo "Please run as root"
    helpFunction
fi

while getopts i:p:d:n:e: opt
do
  case "${opt}" in
    e) INTERFACE=${OPTARG};;
    ?) helpFunction;; # Print helpFunction in case parameter is non-existent
  esac
done

if [ -z "$INTERFACE" ]; then
    echo "No valid interface specified. Use -e <eth_interface> and specify ethernet interface to PON (e.g. enp0s8)"
    helpFunction
fi

NETPLAN_FILE=/etc/netplan/02-network-manager-tibit.yaml

sudo echo "
network:
  version: 2
  vlans:
    $INTERFACE.s4090:
      id: 4090
      link: $INTERFACE
" > $NETPLAN_FILE

#netplan apply

ip link add link $INTERFACE name $INTERFACE.s4090 type vlan id 4090
ip link set down $INTERFACE
#systemctl restart systemd-networkd

