#!/usr/bin/env bash
# --------------------------------------------------------------------------#
#  Copyright (C) 2022 by Tibit Communications, Inc.                         #
#  All rights reserved.                                                     #
#                                                                           #
#     _______ ____  _ ______                                                #
#    /_  __(_) __ )(_)_  __/                                                #
#     / / / / __  / / / /                                                   #
#    / / / / /_/ / / / /                                                    #
#   /_/ /_/_____/_/ /_/                                                     #
#                                                                           #
#                                                                           #
#  Distributed as Tibit-Customer confidential                               #
#                                                                           #
# --------------------------------------------------------------------------#

# Usage
usage () {
    cat <<HELP_USAGE

    $0  [-p public-key] [-r private-key]

    Set netopeer2-cli client ssh keys (default public-key = ${HOME}/.ssh/id_rsa.pub, private-key = ${HOME}/.ssh/id_rsa).

    Options:
      -h|--help       Display this help and usage text.
      -p|--public     Path to the SSH client public key file (default: ${HOME}/.ssh/id_rsa.pub).
      -r|--private    Path to the SSH client private key file (default: ${HOME}/.ssh/id_rsa).

    Example:
      $0 --public ${HOME}/.ssh/id_rsa.pub --private ${HOME}/.ssh/id_rsa

HELP_USAGE

exit 0
}

# Defaults
PUBLIC_KEY=${HOME}/.ssh/id_rsa.pub
PRIVATE_KEY=${HOME}/.ssh/id_rsa

# Parse command line arguments
PARAMS=""
while (( "$#" )); do
    case "$1" in
        -p|--public)
            PUBLIC_KEY=$2
            shift 2
            ;;
        -v|--private)
            PRIVATE_KEY=$2
            shift 2
            ;;
        -h|--help)
            usage
            ;;
        --) # end argument parsing
            shift
            break
            ;;
        -*|--*=) # unsupported option
            echo "Error: Unsupported option $1" >&2
            usage
            ;;
        *) # preserve positional arguments
            PARAMS="$PARAMS $1"
            shift
            ;;
    esac
done
# set positional arguments in their proper place
eval set -- "$PARAMS"

echo "Configuring host keys public-key=${PUBLIC_KEY}, private-key=${PRIVATE_KEY}."

# Execute the command to configure public key authentication, while filtering out benign errors
# The command does the following:
#  1) Removes the old keys at index '0'
#  2) Installs the new public/private key pair
#  3) Sets the SSH public authentication preference to high (i.e, 100) vs. password-based auth
#  4) Displays the configured SSH keys
PATH=${PATH}:/opt/tibit/netconf/bin netopeer2-cli <<COMMANDINPUT 2>&1 | grep -v "nc ERROR: _nc_client_ssh_del_keypair: invalid argument (idx)." | grep -v "auth keys remove: Wrong index"
auth keys remove 0
auth keys add ${PUBLIC_KEY} ${PRIVATE_KEY}
auth pref publickey 100
auth keys
exit
COMMANDINPUT

rm -rf ${TMPFILE}
