"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from drf_spectacular.utils import inline_serializer
from rest_framework import serializers
from rest_framework.fields import CharField


# ==================================================
# ============== Response Serializers ==============
# ==================================================

class OkResponseSerializer(serializers.Serializer):
    """ Serializer for 200 status API responses """
    status = serializers.ChoiceField(default="success", choices=["success", "validation warning"])
    details = serializers.DictField(required=False)
    data = serializers.DictField(required=False)


class CreatedResponseSerializer(serializers.Serializer):
    """ Serializer for 201 status API responses """
    status = serializers.ChoiceField(default="success", choices=["success", "validation warning"])
    details = serializers.DictField(required=False)


class ErrorResponseSerializer(serializers.Serializer):
    """ Serializer for 400-599 status API Responses """
    status = serializers.CharField(default="fail")
    details = serializers.DictField()


# ==================================================
# ============== Request Serializers ===============
# ==================================================

def RequestSerializer(name: str, data_fields: dict):
    """ Returns a serializer with the given fields nested in the 'data' field """
    return inline_serializer(name=name, fields={
        "data": inline_serializer(name=name + "Data", fields=data_fields)
    })


class CharFieldSerializer(serializers.Serializer):
    """ Payload serializer for requests where data is a string """
    data = CharField()
