"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from drf_spectacular.utils import OpenApiResponse, OpenApiParameter, OpenApiExample

import utils.serializers as pm_serializers


class MongoQueryParameter(OpenApiParameter):
    """ Extends OpenApiParameter to describe the 'query' query parameter for get all requests """

    def __init__(self):
        super().__init__("query")
        self.description = "Field keys and values to search for",
        self.examples = [
            OpenApiExample(name="query", value="_id=TBIT4707ff8a,ONU.Name=TibitOnu")
        ]


class MongoProjectionParameter(OpenApiParameter):
    """ Extends OpenApiParameter to describe the 'projection' query parameter for get all requests """

    def __init__(self):
        super().__init__("projection")
        self.description = "Document keys to include in the response data",
        self.examples = [
            OpenApiExample(name="projection", value="ONU.Name,CNTL.CFG Version")
        ]


class ResponseExample(OpenApiResponse):
    """ Sets the description and response format for documentation response examples """

    def __init__(self, status_code):
        super().__init__()

        # Set response serializer and description
        if status_code == 200:
            self.response = pm_serializers.OkResponseSerializer
            self.description = "OK"
        elif status_code == 201:
            self.response = pm_serializers.CreatedResponseSerializer
            self.description = "Created"
        elif status_code == 204:
            self.response = None
            self.description = "No Content"
        else:
            # All error responses use the same serializer
            self.response = pm_serializers.ErrorResponseSerializer
            if status_code == 400:
                self.description = "Bad Request"
            if status_code == 401:
                self.description = "Unauthorized"
            if status_code == 403:
                self.description = "Forbidden"
            if status_code == 404:
                self.description = "Not Found"
            if status_code == 409:
                self.description = "Conflict"
            if status_code == 422:
                self.description = "Unprocessable Entity"
            if status_code == 500:
                self.description = "Internal Server Error"
