#!/usr/bin/env bash

set -e

# optional env variable override
if [ -n "$SYSREPOCFG_EXECUTABLE" ]; then
    SYSREPOCFG="$SYSREPOCFG_EXECUTABLE"
# avoid problems with sudo PATH
elif [ `id -u` -eq 0 ]; then
    SYSREPOCFG=$(su -c 'which sysrepocfg' -l $USER | tail -1)
else
    SYSREPOCFG=$(which sysrepocfg)
fi

# check that there is no nacm configuration yet
SERVER_CONFIG=`$SYSREPOCFG -d startup -X -x "/ietf-netconf-acm:nacm/ietf-netconf-acm:enable-nacm"`
if [ -z "$SERVER_CONFIG" ]; then

# generate edit config
CONFIG="<nacm xmlns=\"urn:ietf:params:xml:ns:yang:ietf-netconf-acm\">
    <enable-nacm>true</enable-nacm>
</nacm>
"
TMPFILE=`mktemp -u`
printf -- "$CONFIG" > $TMPFILE
# apply it to startup and running
echo "Sysrepo setup: enabling NACM."
$SYSREPOCFG --edit=$TMPFILE -d startup -f xml -m ietf-netconf-acm -v2
$SYSREPOCFG -C startup -m ietf-netconf-acm -v2
# remove the tmp file
rm $TMPFILE

fi
